<?php
//This code was created by Plaimanas

$wp_theme_name = "Samutprakarn ";
$wp_theme_shortname = "sm";

// Pull options from database, to use them in the theme
$wp_theme_options = get_option($wp_theme_shortname.'-options');
// Be sure to globalize the variable above in the theme files you'd like to use it in.
global $wp_theme_options; //wrapped in php tags

// Add the admin
function wp_theme_admin() {

// Use Globals
global $wp_theme_name;
global $wp_theme_shortname;

add_theme_page($wp_theme_name." Feed &amp; SEO Options", $wp_theme_name." Feed &amp; SEO Options", 'edit_themes', basename(__FILE__), 'wp_theme_adminpage_print');
}

// Process POST vars
function wp_theme_processforms() {
	
// Use Globals
global $wp_theme_name;
global $wp_theme_shortname;
global $wp_theme_options;
	
	//If User chose to save
	if ( 'save' == $_REQUEST['action'] ) {
	
	// Define and Sanitize (if necessary) before store
	$wp_theme_options['feedburner_url'] = $_POST['feedburner_url'];
	$wp_theme_options['feedburner_id'] = $_POST['feedburner_id'];
	$wp_theme_options['tracking'] = $_POST['tracking'];
	$wp_theme_options['tracking_pos'] = $_POST['tracking_pos'];
	$wp_theme_options['tag_as_keyword'] = $_POST['tag_as_keyword'];
	
	// Store
	update_option($wp_theme_shortname.'-options',$wp_theme_options);
	echo '
	<div class="updated fade" id="message"><p>Theme Options <strong>SAVED</strong>.</p></div>
	';
	}
	
	//If User chose to reset
	else if( 'reset' == $_REQUEST['action'] ) {
	// Delete/Reset
	delete_option($wp_theme_shortname.'-options');
	echo '
	<div class="updated fade" id="message"><p>Theme Options <strong>RESET</strong>.</p></div>
	';
	}
}

// Print admin page
function wp_theme_adminpage_print() {
	
if (isset($_POST['wp_theme_options_submit']) && ($_POST['wp_theme_options_submit'] == 1) ) wp_theme_processforms();

// Set Globals
global $wp_theme_name;
global $wp_theme_shortname;
global $wp_theme_options;
global $wpdb;

// Pull options from database
$wp_theme_options = get_option($wp_theme_shortname.'-options');
// Set variables
extract((array)$wp_theme_options);

wp_theme_adminpage_js(); // custom javascript
wp_theme_options_adminpage_css(); // custom css
?>
<div style="display:none;">
<!--<?php print_r($wp_theme_options); print_r(get_categories()); ?>-->
</div>
    <div class="wrap">
    <h2><?php echo $wp_theme_name; ?> Feed & SEO Settings</h2>
    <form method="post" action="" id="wp_theme_options">
	<?php wp_nonce_field('wp_theme_options_submit'); ?>
	<table class="form-table"><tbody>
	<input type="hidden" name="wp_theme_options_submit" value="1"/>
    
	<tr><th scope="row">Feedburner Information</th>
	<td>If you use a site like <a href="http://feedburner.com/">Feedburner</a> to handle your feeds, please enter your feed URL here (including http://):<br />
	<input type="text" value="<?php echo $feedburner_url; ?>" name="feedburner_url" id="feedburner_url" class="textbox"> (leave blank for none)<br /><br />
	
	If you have activeated Feedburner's Email Subscription Option, enter your <a href="http://www.nathanrice.net/blog/whats-my-feedburner-id/">Feedburner ID</a> below:<br />
	<input type="text" value="<?php echo $feedburner_id; ?>" name="feedburner_id" id="feedburner_id" class="textbox"> (leave blank for none)
	</td></tr>
	
	<tr><th scope="row">Tracking Code</th>
	<td>If you use a tracking service like <a href="http://google.com/analytics">Google Analytics</a>, paste the tracking code in the box below:<br />
	(leave blank for none)<br />
	<textarea name="tracking" id="tracking" class="textarea" rows="3" cols="50"><?php echo stripslashes($tracking); ?></textarea><br />
	Does your tracking service go in the header or footer of the code?<br />
	<input type="radio" name="tracking_pos" value="header" <?php if($tracking_pos == 'header') echo 'checked'; ?>> Header<br />
	<input type="radio" name="tracking_pos" value="footer" <?php if($tracking_pos == 'footer') echo 'checked'; ?>> Footer
	</td></tr>
	
	<tr><th scope="row">Search Engine Optimization</th>
	<td>Would You like to use post tags as <a href="http://en.wikipedia.org/wiki/Meta_element#The_keywords_attribute" target="_blank">META keywords</a> on single posts? (recommended)<br />
	<input type="radio" name="tag_as_keyword" value="yes" <?php if($tag_as_keyword == 'yes') echo 'checked'; ?>> Yes<br />
	<input type="radio" name="tag_as_keyword" value="no" <?php if($tag_as_keyword == 'no') echo 'checked'; ?>> No<br />
	<strong>NOTE:</strong> By default, this theme uses either <a href="http://codex.wordpress.org/Template_Tags/the_excerpt_rss" target="_blank">the excerpt</a> on single posts or pages,<br />
	or the blog <a href="<?php bloginfo('wpurl'); ?>/wp-admin/options-general.php" target="_blank">tagline</a> on all other pages (home, archives, etc.) as the <a href="http://en.wikipedia.org/wiki/Meta_element#The_description_attribute" target="_blank">META description</a>.<br /><br />
	
	</td></tr>
		
	</tbody></table>
	
	<p class="submit">
	<input name="save" type="submit" value="Save Options &raquo;" />	
	<input type="hidden" name="action" value="save" />
	</p>
	</form>
	<form method="post">
	<p class="submit">
	<input name="reset" type="submit" value="Reset Options &raquo;" />
	<input type="hidden" name="wp_theme_options_submit" value="1"/>
	<input type="hidden" name="action" value="reset" />
	</p>
	</form>

	</form>
	</div>
<?php }
function wp_theme_options_adminpage_css() { //if you would like to add CSS to the admin page
	echo <<<CSS
	<style type="text/css">
		#wp_theme_options .dropdown {
			width: 210px;
		}
		#wp_theme_options .multiselect {
			height: 100px;
			width: 210px;
		}
		#wp_theme_options .textbox {
			width: 400px;
		}
		#wp_theme_options .textarea {
			width: 400px;
		}
	</style>
	
	
CSS;
}
function wp_theme_adminpage_js() { // if you would like to add javascript to the admin page
	echo <<<JS
	<script type="text/javascript">
	jQuery().ready(function() {  
		jQuery('#add').click(function() {  
			return !jQuery('#cat_opt option:selected').remove().appendTo('#post_by_cat');  
		});  
		jQuery('#remove').click(function() {  
			return !jQuery('#post_by_cat option:selected').remove().appendTo('#cat_opt');  
		});
		jQuery('form').submit(function() {  
			jQuery('#post_by_cat option').each(function(i) {  
				jQuery(this).attr("selected", "selected");  
			});  
		});
	});  
	</script>
JS;

}
add_action('admin_menu', 'wp_theme_admin'); 
?>