<?php
//The Widgetization Code (sidebar, under adsense)
if ( function_exists('register_sidebar') ) {
register_sidebar(array('name'=>'Right Sidebar','before_widget' => '<div class="widget">','after_widget' => '</div>','before_title' => '<h4>','after_title' => '</h4>',)); }

//Define the wp_content DIR for backward compatibility
if (!defined('WP_CONTENT_URL'))
	define('WP_CONTENT_URL', get_option('site_url').'/wp-content');
if (!defined('WP_CONTENT_DIR'))
	define('WP_CONTENT_DIR', ABSPATH.'/wp-content');
	
//Define the content width for images
$max_width = 323;
$GLOBALS['content_width'] = 323;

///////////////////////////////
//Include modularized lib files
///////////////////////////////
//Custom Breadcrumb plugin
include(TEMPLATEPATH."/lib/breadcrumb.php");

//Default Custom Field code
include(TEMPLATEPATH."/lib/custom-fields.php");
 

//Legacy Code (for backward compatibility)
if(!function_exists('wp_page_menu')) { //if pre-2.7
include(TEMPLATEPATH."/legacy/legacy.php"); }

//wp_page_menu argument filter
add_filter('wp_page_menu_args','skyye_page_menu_args');
function skyye_page_menu_args($args) {
	$exclude = get_skyye_option('exclude_pages');
	$show_home = (!in_array('home',(array)$exclude)) ? 1 : 0;
	$exclude_pages = implode(',',(array)$exclude);
	$args = array('show_home' => $show_home,
				'title_li' => '', 'sort_column' => 'post_title',
				'menu_class' => 'menu', 'echo' => true,
				'exclude' => $exclude_pages);
	return $args;
}
    
//A function to include files throughout the theme
//It checks to see if the file exists first, so as to avoid error messages.
function get_template_file($filename) {
if (file_exists(TEMPLATEPATH."/$filename"))
include(TEMPLATEPATH."/$filename");
}

//A function to RETURN the content
//of a theme option, defined as an argument.
function get_skyye_option($option) {
	global $wp_theme_options;
	$option = $wp_theme_options[$option];
	$option = (!is_array($option)) ? stripslashes($option) : $option;
	if(!$option) return FALSE;
	return $option;
}
//A function to ECHO the content
//of a theme option, defined as an argument.
function skyye_option($option) {
	echo get_skyye_option($option);
}

//A simple function to get data stored in a custom field
function get_custom_field($field) {
	global $post;
	$custom_field = get_post_meta($post->ID, $field, true);
	echo $custom_field;
}

//A function to get custom field image attachment...
//if there is none, use default image
function image_attachment($field, $width, $height) {
	global $post;
	$custom_field = get_post_meta($post->ID, $field, true);
	//default fallback URL and PATH
	$default_img = get_bloginfo('template_url').'/images/'.$field.'.png';
	$default_img_path = TEMPLATEPATH.'/images/'.$field.'.png';
	
	if($custom_field) { //if the user set a custom field
		echo '<img src="'.$custom_field.'" alt="'.get_the_title().'" width="'.$width.'" height="'.$height.'"/>';
	}
	elseif (file_exists($default_img_path)) { //if the fallback image exists
		echo '<img src="'.$default_img.'" alt="'.get_the_title().'" width="'.$width.'" height="'.$height.'"/>';
	}
	else { //if fallback image does not exist, use a grey block div
		echo '<div style="background: #FFF; width: '.$width.'px; height: '.$height.'px; color: #FFF; text-align: center; float: left;"></div>';
	}
}


	

function new_excerpt_more($excerpt) {
	return str_replace('[...]', '...', $excerpt);
}
add_filter('wp_trim_excerpt', 'new_excerpt_more');

$catty = "<?php the_category(''); ?>";


function wp_pagenavi($before = '', $after = '', $prelabel = '', $nxtlabel = '', $pages_to_show = 5, $always_show = false) {
	global $request, $posts_per_page, $wpdb, $paged;
	if(empty($prelabel)) {
		$prelabel  = '<strong class="pagination-prev">&laquo;</strong>';
	}
	if(empty($nxtlabel)) {
		$nxtlabel = '<strong class="pagination-next">&raquo;</strong>';
	}
	$half_pages_to_show = round($pages_to_show/2);
	if (!is_single()) {
		if(!is_category()) {
			preg_match('#FROM\s(.*)\sORDER BY#siU', $request, $matches);		
		} else {
			preg_match('#FROM\s(.*)\sGROUP BY#siU', $request, $matches);		
		}
		$fromwhere = $matches[1];
		$numposts = $wpdb->get_var("SELECT COUNT(DISTINCT ID) FROM $fromwhere");
		$max_page = ceil($numposts /$posts_per_page);
		if(empty($paged)) {
			$paged = 1;
		}
		if($max_page > 1 || $always_show) {
			echo "$before <div class='pagination'><span>
</span>";
			if ($paged >= ($pages_to_show-1)) {
				echo '<a href="'.get_pagenum_link().'" class="pagination-first">&laquo; First</a> ... ';
			}
			previous_posts_link($prelabel);
			for($i = $paged - $half_pages_to_show; $i  <= $paged + $half_pages_to_show; $i++) {
				if ($i >= 1 && $i <= $max_page) {
					if($i == $paged) {
						echo "<strong class='on'><u>$i</u></strong>";
					} else {
						echo ' <a href="'.get_pagenum_link($i).'" class="pagination-number">'.$i.'</a> ';
					}
				}
			}
			next_posts_link($nxtlabel, $max_page);
			if (($paged+$half_pages_to_show) < ($max_page)) {
				echo ' ... <a href="'.get_pagenum_link($max_page).'" class="pagination-last">Last &raquo;</a>';
			}
			echo "</div> $after";
		}
	}
}

function m_paginate() {
	global $wp_query, $wp_rewrite;
	$wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;
	$pagination = array(
		'base' => @add_query_arg('page','%#%'),
		'format' => '',
		'total' => $wp_query->max_num_pages,
		'current' => $current,
		'show_all' => true,
		'type' => 'plain'
	);
	if ( $wp_rewrite->using_permalinks() ) $pagination['base'] = user_trailingslashit( trailingslashit( remove_query_arg( 's', get_pagenum_link( 1 ) ) ) . 'page/%#%/', 'paged' );
	if ( !empty($wp_query->query_vars['s']) ) $pagination['add_args'] = array( 's' => get_query_var( 's' ) );
	echo paginate_links( $pagination );
}


//make chlild cat use parent template
function load_cat_parent_template()
{
    global $wp_query;

    if (!$wp_query->is_category)
        return true; // saves a bit of nesting

    // get current category object
    $cat = $wp_query->get_queried_object();

    // trace back the parent hierarchy and locate a template
    while ($cat && !is_wp_error($cat)) {
        $template = TEMPLATEPATH . "/category-{$cat->slug}.php";

        if (file_exists($template)) {
            load_template($template);
            exit;
        }

        $cat = $cat->parent ? get_category($cat->parent) : false;
    }
}
add_action('template_redirect', 'load_cat_parent_template');

?>